﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private rand As New Random()
    Private isDrawing, isDragging As Boolean
    Private path As Path
    Private ellipseGeo As EllipseGeometry


    Public Sub New()
        InitializeComponent()
    End Sub


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        If isDrawing OrElse isDragging Then
            Return
        End If

        If TypeOf args.OriginalSource Is Path Then
            ellipseGeo = TryCast((TryCast(args.OriginalSource, Path)).Data, EllipseGeometry)

            isDragging = True
            args.ManipulationContainer = ContentPanel
            args.Handled = True
        ElseIf args.OriginalSource Is ContentPanel Then
            ellipseGeo = New EllipseGeometry()
            ellipseGeo.Center = args.ManipulationOrigin
            path = New Path()
            path.Stroke = TryCast(Me.Resources("PhoneForegroundBrush"), Brush)
            path.Data = ellipseGeo
            ContentPanel.Children.Add(path)

            isDrawing = True
            args.Handled = True
        End If

        MyBase.OnManipulationStarted(args)
    End Sub


    Protected Overrides Sub OnManipulationDelta(ByVal args As ManipulationDeltaEventArgs)
        If isDragging Then
            Dim center = ellipseGeo.Center
            center.X += args.DeltaManipulation.Translation.X
            center.Y += args.DeltaManipulation.Translation.Y
            ellipseGeo.Center = center

            args.Handled = True
        ElseIf isDrawing Then
            Dim translation = args.CumulativeManipulation.Translation
            Dim radius = Math.Max(Math.Abs(translation.X),
                                  Math.Abs(translation.Y))
            ellipseGeo.RadiusX = radius
            ellipseGeo.RadiusY = radius

            args.Handled = True
        End If

        MyBase.OnManipulationDelta(args)
    End Sub


    Protected Overrides Sub OnManipulationCompleted(ByVal args As ManipulationCompletedEventArgs)
        If isDragging Then
            isDragging = False
            args.Handled = True
        ElseIf isDrawing Then
            Dim clr = Color.FromArgb(255, CByte(rand.Next(256)),
                                                   CByte(rand.Next(256)),
                                                   CByte(rand.Next(256)))
            path.Fill = New SolidColorBrush(clr)

            isDrawing = False
            args.Handled = True
        End If

        MyBase.OnManipulationCompleted(args)
    End Sub
End Class

